/*
    Configure corretamente os eventos e as configurações
    Evite eventos duplicados com o mesmo nome!!

    Dia das semanas

    1 = Domingo
    2 = Segunda
    3 = Terça
    4 = Quarta
    5 = Quinta
    6 = Sexta
    7 = Sábado
*/
const eventsConfig = {
    timezone: "America/Sao_Paulo",
    notifications: {
        title: "Notificação de Evento",
        alert1: "O {event} começa em 5 minutos",
        alert2: "O {event} começou",
        icon: "icon.ico",
        timeout: "never"
    }
};

const events = [
    [
        "Blood Castle", // Nome do evento
        ["00:10", "02:10", "04:10", "06:10", "08:10", "10:10", "12:10", "14:10", "16:10", "18:10", "20:10", "22:10"], // horarios dos eventos
    ],
    [
        "Battle Royale", // Nome do evento
        [2, 4], // Dias da semana
        [
            ["19:52", "19:55"], // Horários do dia 2
            ["09:00", "18:00"] // Horários do dia 4
        ]
    ],
    [
        "Guild vs Guild", // Nome do evento
        [2], // Dia da semana
        [
            ["19:56"] // Horários do dia 2
        ]
    ],
    [
        "Chaos Castle", // Nome do evento
        ["01:00", "03:00", "05:00", "07:00", "09:00", "11:00", "13:00", "15:00", "17:00", "19:00", "21:00", "23:00"], // horarios dos eventos
    ],
    [
        "Ilusion Temple", // Nome do evento
        ["01:30", "05:30", "09:30", "13:30", "17:30", "21:30"], // horarios dos eventos
    ],
    [
        "Castle Deep", // Nome do evento
        ["03:37"], // horarios dos eventos
    ],
    [
        "CryWolf", // Nome do evento
        ["20:30"], // horarios dos eventos
    ],
    [
        "Devil Square", // Nome do evento
        ["00:40", "02:40", "04:40", "06:40", "08:40", "10:40", "12:40", "14:40", "16:40", "18:40", "20:40", "22:40"], // horarios dos eventos
    ],
    [
        "Moss Merchant", // Nome do evento
        ["02:00", "08:00", "14:00", "20:00"], // horarios dos eventos
    ],
    [
        "Fênix Icarus", // Nome do evento
        "respawn after 12h time"
    ],

];

const invasions = [
    [
        "Blood Castle", // Nome do evento
        ["00:10", "02:10", "04:10", "06:10", "08:10", "10:10", "12:10", "14:10", "16:10", "18:10", "20:10", "22:10"], // horarios dos eventos
    ],
    [
        "Wênix Icarus", // Nome do evento
        "respawn after 12h time"
    ],
];

const bosses = [
    [
        "Fênix Icarus", // Nome do evento
        ["02:30", "09:30", "15:30", "22:30"], // horarios dos eventos
    ],
    [
        "Anubis", // Nome do evento
        ["04:30", "11:30", "17:30"], // horarios dos eventos
    ],
    [
        "Hades", // Nome do evento
        ["05:00", "12:00", "18:00"], // horarios dos eventos
    ],
    [
        "Morpheus", // Nome do evento
        [2, 4], // Dias da semana (2 = Segunda-feira, 4 = Quarta-feira)
        [["19:52", "19:55"], ["09:00", "18:00"]] // Horários para cada dia da semana
    ],
    [
        "Centauro", // Nome do evento
        [2], // Dia da semana (1 = Domingo)
        [["19:56"]] // Horários para o domingo
    ],
    [
        "World Boss", // Nome do evento
        "respawn after 12h time"
    ],
];