document.addEventListener('DOMContentLoaded', () => {
  // Função para carregar e definir os valores dos campos
  const loadSettings = async () => {
    try {
      // Carregar e definir a configuração do som
      const soundEffects = await window.electron.getSoundEffects();
      document.getElementById('sound').checked = soundEffects === 1;

      // Carregar e definir a configuração da música de fundo
      const music = await window.electron.getMusic();
      document.getElementById('music').checked = music === 1;

      const windowMode = await window.electron.getWindow();
      document.getElementById('window').checked = windowMode === 1;

      // Carregar e definir a configuração da resolução
      const resolution = await window.electron.getResolution();
      document.getElementById('resolution').value = resolution || '0'; // Definir padrão para 0 se não houver valor

      // Carregar e definir a configuração da linguagem
      const langSelection = await window.electron.getLangSelection();
      document.getElementById('LangSelection').value = langSelection || 'Eng'; // Definir padrão para 'Eng' se não houver valor

      // Carregar e definir a configuração de profundidade de cor
      const colorDepth = await window.electron.getColorDepth();
      document.getElementById(colorDepth === 8 ? 'mincolor' : 'maxcolor').checked = true;

      // Carregar e definir o ID da conta
      const accountId = await window.electron.getId();
      document.getElementById('login').value = accountId || ''; // Definir padrão se não houver valor

      // Main Dep é desativado por padrão, então não é necessário carregá-lo
    } catch (err) {
      console.error('Error loading settings:', err);
    }
  };

  loadSettings();

  // Função para salvar as configurações
  const saveSettings = async () => {
    try {
      // Salvar a configuração do som
      const isSoundOn = document.getElementById('sound').checked;
      await window.electron.setSoundEffects(isSoundOn ? 1 : 0);

      // Salvar a configuração da música de fundo
      const isMusicOn = document.getElementById('music').checked;
      await window.electron.setMusic(isMusicOn ? 1 : 0);

      const isWindowOn = document.getElementById('window').checked;
      await window.electron.setWindow(isWindowOn ? 1 : 0);

      // Salvar a configuração da resolução
      const resolution = document.getElementById('resolution').value;
      await window.electron.setResolution(resolution);

      // Salvar a configuração da linguagem
      const langSelection = document.getElementById('LangSelection').value;
      await window.electron.setLangSelection(langSelection);

      // Salvar a configuração de profundidade de cor
      const colorDepth = document.querySelector('input[name="color"]:checked').id === 'mincolor' ? 8 : 10;
      await window.electron.setColorDepth(colorDepth);

      // Salvar o ID da conta
      const accountId = document.getElementById('login').value;
      await window.electron.setId(accountId);

      // Salvar a configuração do Main DEP (por padrão, está desativado)
      const isMainDepOn = document.getElementById('maindep').checked;
      await window.electron.setMainDep(isMainDepOn);

      alert('Settings saved successfully!');
    } catch (err) {
      console.error('Error saving settings:', err);
      alert('Error saving settings.');
    }
  };

  document.querySelector('.save').addEventListener('click', (e) => {
    e.preventDefault();
    saveSettings();
  });
});
