window.electron.onUpdateProgress((data) => {
    const progressBar = document.getElementById("progress-bar");

    // Atualiza o progresso dependendo se é download ou extração
    progressBar.style.width = `${data.percentComplete}%`;

    // Atualiza o status e o texto "Downloading" ou "Extracting"
    if (data.textType === 'Downloading') {
        document.querySelector('.text1').textContent = `Downloading: ${data.fileName}`;
        document.getElementById("status").textContent = `Baixando arquivos...`;
        document.getElementById("files").textContent = `Baixando: ${data.fileName}`;
    } else if (data.textType === 'Extracting') {
        document.querySelector('.text1').textContent = `Extract: ${data.fileName}`;
        document.getElementById("status").textContent = `Descompactando arquivos...`;
        document.getElementById("total-files").textContent = `Arquivos restantes: ${data.totalFiles}`;
    }

    // Atualiza a versão atual/total se ambos os valores estiverem definidos
    if (data.currentVersion !== undefined && data.latestVersion !== undefined) {
        document.querySelector('.currentversion').textContent = data.currentVersion;
        document.querySelector('.latestversion').textContent = data.latestVersion;
    }

    // Exibe a velocidade (seja de download ou extração)
    if (data.speed) {
        const speedElement = document.getElementById("speed");
        speedElement.textContent = `Velocidade: ${data.speed} ${data.textType === 'Downloading' ? 'MB/s' : 'arquivos/s'}`;
        speedElement.style.display = "block";
    }
});


window.electron.onDownloadSpeed((data) => {
    const speedElement = document.getElementById("speed");

    if (data.type === 'download') {
        // Exibe a velocidade de download
        speedElement.textContent = `Download: ${data.speed} MB/s`;
        speedElement.style.display = "block";
    } else if (data.type === 'extract') {
        // Exibe a velocidade de extração
        speedElement.textContent = `Extração: ${data.speed} arquivos/s`;
        speedElement.style.display = "block";
    }
});


  