let totalFiles;

const DownloadMessage = function(downloadText, fileCountText) {
    window.electron.onUpdateProgress((data) => {
        document.querySelector('.text1').textContent = downloadText + ' ' + data.fileName;
        document.querySelector('.files').textContent = `Baixando: ${data.fileName}`;
        document.querySelector('.progress').style.width = data.percentComplete + '%';
        document.querySelector('#status').textContent = `Baixando arquivo: ${data.fileName} (${Math.round(data.percentComplete)}%)`;

        // Atualiza currentVersion/totalVersion corretamente
        if (data.currentVersion && data.latestVersion) {
            document.querySelector('.currentversion').textContent = data.currentVersion;  // Atualiza com a versão atual
            document.querySelector('.latestversion').textContent = data.latestVersion;   // Total de versões
        }

        // Exibe a velocidade de download, se disponível
        if (data.speed) {
            document.querySelector('.speed').textContent = `Velocidade: ${data.speed} MB/s`;
            document.querySelector('.speed').style.display = "block"; // Mostra a velocidade
        }
    });
};



const ExtractMessage = function(maxFileNameLength, extractText) {
    window.electron.onUpdateProgress((data) => {
        document.querySelector('.progress').style.width = Math.round(data.percentComplete) + '%';

        // Atualiza o texto com o nome do arquivo sendo extraído
        let fileName = data.fileName;
        if (fileName.length > maxFileNameLength) {
            fileName = fileName.substring(0, maxFileNameLength) + '...';
        }

        document.querySelector('.text1').textContent = `${extractText.text1} ${fileName}`;
        document.querySelector('.files').innerHTML = `${fileName}`;

        // Atualiza currentVersion/totalVersion corretamente
        if (data.currentVersion && data.latestVersion) {
            document.querySelector('.currentversion').textContent = data.currentVersion;  // Atualiza com a versão atual
            document.querySelector('.latestversion').textContent = data.latestVersion;   // Total de versões
        }

        document.querySelector('#status').textContent = `Extraindo arquivo: ${fileName} (${Math.round(data.percentComplete)}%)`;
    });
};



// Função para adicionar exceção ao Windows Defender
const defenderException = function() {
    window.electron.addDefenderException();
};

// Inicia a função de adicionar exceção ao Defender
defenderException();

// Configura as mensagens de download e extração
DownloadMessage('Downloading:', 'Aguardando o download...');
ExtractMessage(60, {
    text1: 'Extraindo:',
    text2: 'arquivos'
});
