defenderException();

const imageNews = $('.news .photo');
const imagesNews = ['bk.png', 'elf.png'];
let imageIndex = 0;

function newsRotate() {
	imageNews.css('background-image', 'url(assets/images/news/' + imagesNews[imageIndex] + ')');
	imageIndex = (imageIndex + 1) % imagesNews.length;
}

newsRotate();

setInterval(newsRotate, 5000);

$('#volume').on('input', function(){
	var valor = $(this).val();
	$('.number').text(valor);
});

(async () => {
    try {
        const RegEdit = await GetRegEdit(
			['ID', 'Resolution', 'DisplayColorBit', 'SoundOnOff', 'MusicOnOff', 'VolumeLevel', 'LangSelection', 'WindowMode']
		);

		for (const nameKey in RegEdit) {
			if (RegEdit.hasOwnProperty(nameKey)) {

				const value = RegEdit[nameKey];

				if(nameKey == "ID") {
					$("#login").val(value);
				}

				if(nameKey == "Resolution") {
					$('#resolution option[value="' + value + '"]').prop('selected', true);
				}

				if(nameKey == "DisplayColorBit") {
					if(value == 8) {
						$("#mincolor").attr('checked', true)
					}
					if(value == 16) {
						$("#maxcolor").attr('checked', true)
					}
				}

				if(nameKey == "SoundOnOff") {
					if(value == 1) {
						$("#sound").attr('checked', true)
					}
				}

				if(nameKey == "MusicOnOff") {
					if(value == 1) {
						$("#music").attr('checked', true)
					}
				}

				if(nameKey == "VolumeLevel") {
					$("#volume").val(value);
					$('.count-range').html(value);
					$("#number").html(value);
				}

				if(nameKey == "LangSelection") {
					$('#language option[value="' + value + '"]').prop('selected', true);
				}

				if(nameKey ==  "WindowMode") {
					if(value == 1) {
						$("#winmode").attr('checked', true)
					}
				}
			}
		}

    } catch (error) {
        console.error('Erro ao obter as informações do regedit:', error);
    }

	const isValuePresent = await depException('check', 'main.exe');

	if(isValuePresent) {
		$("#maindep").attr('checked', true);
	}

})();

$("#minimize").click(function() {
	Minimizer();
});

$("#closed").click(function() {
	Closed();
});

$("#start").click(async function(event) {
    $(this).prop('disabled', true);
    await Start('Connect', 'main.exe');
    $(this).off(event);
});

$('a').click(function(e) {
	e.preventDefault();

	const url = $(this).attr('href');

	Url(url);
});

$("#settings").click(function() {
	$(".bg-settings").fadeIn();
});

$(".bg-settings .closed").click(function () {
	$(".bg-settings").fadeOut();
});

$("#form").submit(function(e) {

	e.preventDefault();

	var account = $("#login").val();
	var resolution = $("#resolution").val();
	var mincolor = $("#mincolor").prop('checked');
	var maxcolor = $("#maxcolor").prop('checked');
	var soundC = $("#sound").prop('checked');
	var musicC = $("#music").prop('checked');
	var winmode = $("#winmode").prop('checked');
	var volume =  $("#volume").val();
	var language = $("#language").val();
	var dep = $("#maindep").prop('checked');

	var color = 0;
	var music = 0;
	var sound = 0;

	if(mincolor === true) { color = 8;}
	if(maxcolor === true) { color = 16;}
	if(musicC === true) { music = 1;}
	if(soundC === true) { sound = 1;}

	if(winmode === true) {
		UpdateRegEdit('REG_DWORD', 'WindowMode', '1');
	} else {
		UpdateRegEdit('REG_DWORD', 'WindowMode', '0');
	}

	if(dep === true) {
		depException('add', 'main.exe');
	} else {
		depException('remove', 'main.exe');
	}

	// Enviando as requisições pro reg edit
	UpdateRegEdit('REG_SZ', 'ID', account);
	UpdateRegEdit('REG_DWORD', 'Resolution', resolution);
	UpdateRegEdit('REG_DWORD', 'DisplayColorBit', color);
	UpdateRegEdit('REG_DWORD', 'SoundOnOff', sound);
	UpdateRegEdit('REG_DWORD', 'MusicOnOff', music);
	UpdateRegEdit('REG_DWORD', 'VolumeLevel', volume);
	UpdateRegEdit('REG_SZ', 'LangSelection', language);

	$(".bg-settings").fadeOut();
});