document.addEventListener('DOMContentLoaded', () => {
  const loadSettings = async () => {
    try {

      const soundEffects = await window.electron.getSoundEffects();
      document.getElementById('sound').checked = soundEffects === 1;


      const music = await window.electron.getMusic();
      document.getElementById('music').checked = music === 1;

      const windowMode = await window.electron.getWindow();
      document.getElementById('window').checked = windowMode === 1;

      const resolution = await window.electron.getResolution();
      document.getElementById('resolution').value = resolution || '0'; 

      const langSelection = await window.electron.getLangSelection();
      document.getElementById('LangSelection').value = langSelection || 'Eng'; 

      const colorDepth = await window.electron.getColorDepth();
      document.getElementById(colorDepth === 8 ? 'mincolor' : 'maxcolor').checked = true;

      const accountId = await window.electron.getId();
      document.getElementById('login').value = accountId || ''; 

    } catch (err) {
      console.error('Error loading settings:', err);
    }
  };

  loadSettings();

  const saveSettings = async () => {
    try {

      const isSoundOn = document.getElementById('sound').checked;
      await window.electron.setSoundEffects(isSoundOn ? 1 : 0);

      const isMusicOn = document.getElementById('music').checked;
      await window.electron.setMusic(isMusicOn ? 1 : 0);

      const isWindowOn = document.getElementById('window').checked;
      await window.electron.setWindow(isWindowOn ? 1 : 0);

      const resolution = document.getElementById('resolution').value;
      await window.electron.setResolution(resolution);

      const langSelection = document.getElementById('LangSelection').value;
      await window.electron.setLangSelection(langSelection);

      const colorDepth = document.querySelector('input[name="color"]:checked').id === 'mincolor' ? 8 : 10;
      await window.electron.setColorDepth(colorDepth);

      const accountId = document.getElementById('login').value;
      await window.electron.setId(accountId);

      const isMainDepOn = document.getElementById('maindep').checked;
      await window.electron.setMainDep(isMainDepOn);

      alert('Settings saved successfully!');
    } catch (err) {
      console.error('Error saving settings:', err);
    }
  };

  document.querySelector('.save').addEventListener('click', (e) => {
    e.preventDefault();
    saveSettings();
  });
});
