// functions.js

// Alterna as abas da dashboard
$('.navbar-dash ul li').click(function() {
    var $data = $(this).data('button');

    $('.navbar-dash ul li').removeClass('active');
    $('.list-c').removeClass('active');

    $(this).addClass('active');
    $("#" + $data).addClass('active');
});

// Alterna as subcategorias de eventos (eventos, bosses, invasões)
$('.events-names li').click(function() {
    var $data = $(this).data('event');

    $('.events-names li').removeClass('active');
    $('.list-e').removeClass('active');

    $(this).addClass('active');
    $("#" + $data).addClass('active');
});

// Minimiza a janela ao clicar no botão de minimizar
$("#minimizer").click(function() {
    window.electronAPI.minimizeDash();
});

// Fecha a janela ao clicar no botão de fechar
$("#closed").click(function() {
    window.electronAPI.closeDash();
});

// Previne o comportamento padrão de links e envia a URL para o processo principal
$('a').click(function(e) {
    e.preventDefault();

    const url = $(this).attr('href');
    window.electronAPI.sendUrl(url);
});

// Função de alternância de notificações
document.addEventListener('DOMContentLoaded', () => {
    const notifyIcon = document.getElementById('notify');
    let notificationsEnabled = true; // Estado inicial

    notifyIcon.addEventListener('click', () => {
        notificationsEnabled = !notificationsEnabled;

        // Atualizar a interface visual
        if (notificationsEnabled) {
            notifyIcon.classList.remove('off');
            notifyIcon.classList.add('on');
            notifyIcon.setAttribute('title', 'Desativar notificações gerais');
        } else {
            notifyIcon.classList.remove('on');
            notifyIcon.classList.add('off');
            notifyIcon.setAttribute('title', 'Ativar notificações gerais');
        }

        // Enviar mensagem para o processo principal
        window.electronAPI.setNotificationsEnabled(notificationsEnabled);
    });

    // Tooltip deve ser atualizado quando o título muda
    $('[data-toggle="tooltip"]').tooltip('dispose').tooltip();
});
