// assets/plugins/events/init.js

$(document).ready(async function() {
    // Função para iniciar a atualização dos eventos
    const initializeEvents = async () => {
        try {
            await updateEvents(events, 'events');
            await updateEvents(bosses, 'bosses');
            await updateEvents(invasions, 'invasions');
        } catch (error) {
            console.error('Erro ao atualizar eventos:', error);
        }
    };

    // Inicializa os eventos ao carregar a página
    await initializeEvents();

    // Atualiza os eventos a cada segundo
    setInterval(async () => {
        await initializeEvents();
    }, 1000);
});
