// Função para buscar dados do widget do Discord e atualizar o HTML
const getApiDiscord = () => {
    let htmlContent = '';
    let userCount = 0;
    
    $.ajax({
        type: 'GET',
        url: settingsDs['widget'], // URL do widget do Discord
        dataType: 'json',
        success: function(response) {
            // Itera sobre os membros retornados pela API
            for (const user of response['members']) {
                if (userCount < 9) { // Limita a exibição a 9 usuários
                    htmlContent += `
                        <div class="user">
                            <div class="photo" style="background: url('${user['avatar_url']}'); background-size: contain;" data-toggle="tooltip" data-placement="bottom" title="${user['username']}">
                            </div>
                            <div class="username">${user['username']}</div>
                            <div class="status">${user['status']}</div>
                        </div>
                    `;
                    userCount++;
                } else {
                    break;
                }
            }
            // Atualiza o elemento com ID 'discord' com o HTML construído
            $('#discord').html(`
                <div class="list">
                    ${htmlContent}
                </div>
                <div class="footer">
                    <p><i class="online"></i>${response['presence_count']} Onlines</p>
                    <div class="button"><a onclick="Url('${settingsDs['invitation']}')" target="_blank" >Channel</a></div>
                </div>
            `);
        }
    });
};

// Quando o documento estiver pronto, executa a função e configura um intervalo para atualização
$(document).ready(function(){
    getApiDiscord();
    setInterval(async function(){
        await getApiDiscord();
    }, settingsDs['refresh']); // Intervalo definido em milissegundos
});