window.electron.onUpdateProgress((data) => {
    const progressBar = document.getElementById("progress-bar");
    progressBar.style.width = `${data.percentComplete}%`;

    // Remova a exibição da porcentagem ao lado do nome do arquivo
    if (data.totalFiles !== undefined) {
        document.getElementById("status").textContent = `Descompactando arquivos`;
        document.getElementById("total-files").textContent = `Arquivos restantes: ${data.totalFiles}`;
        document.getElementById("progress-bar").style.width = `${data.percentComplete}%`;
    } else {
        document.getElementById("status").textContent = `Baixando arquivos...`;
        document.getElementById("files").textContent = `Baixando: ${data.fileName}`; // Apenas o nome do arquivo
        document.getElementById("progress-bar").style.width = `${data.percentComplete}%`;
    }

    const speedElement = document.getElementById("speed");
    if (!speedElement.style.display || speedElement.style.display === "none") {
      speedElement.style.display = "block";
    }
});

window.electron.onDownloadSpeed((speed) => {
    const speedElement = document.getElementById("speed");
    speedElement.textContent = `Velocidade: ${speed} MB/s`; // Exibe a velocidade em MB/s corretamente
    
    // Garante que o elemento de velocidade esteja visível
    if (!speedElement.style.display || speedElement.style.display === "none") {
        speedElement.style.display = "block";
    }
  });


  