let totalFiles;

// Função para manipular a mensagem durante o download
const DownloadMessage = function(downloadText, fileCountText) {
    window.electron.onUpdateProgress((data) => {
        // Remove a porcentagem do nome do arquivo
        document.querySelector('.text1').textContent = downloadText + ' ' + data.fileName;
        document.querySelector('.files').textContent = `Baixando: ${data.fileName}`;
        document.querySelector('.progress').style.width = data.percentComplete + '%';
        document.querySelector('#status').textContent = 'Baixando arquivos...';

        // Exibe a velocidade de download, se disponível
        if (data.speed) {
            document.querySelector('.speed').textContent = `Velocidade: ${data.speed} MB/s`;
        }

        // Atualiza apenas o currentVersion e latestVersion
        if (data.currentVersion) {
            document.querySelector('.currentversion').textContent = data.currentVersion;
        }
        if (data.latestVersion) {
            document.querySelector('.latestversion').textContent = data.latestVersion;
        }
    });
};


// Função para manipular a mensagem durante a extração
const ExtractMessage = function(maxFileNameLength, extractText) {
    window.electron.on('extract-message', (event, extractData) => {
        document.querySelector('.progress').style.width = Math.round(extractData.currentProgress) + '%';

        // Atualiza o texto com o nome do arquivo sendo extraído
        document.querySelector('.text1').textContent = `${extractText.text1} ${extractData.fileNumber} ${extractText.text2}`;
        
        let fileName = extractData.fileName;
        if (fileName.length > maxFileNameLength) {
            fileName = fileName.substring(0, maxFileNameLength) + '...';
        }

        document.querySelector('.files').innerHTML = `Extraindo: ${fileName}`;
        document.querySelector('.currentversion').textContent = extractData.currentVersion;
        document.querySelector('.latestversion').innerHTML = extractData.latestVersion;

        document.querySelector('#status').textContent = 'Descompactando arquivos...';
    });
};


// Função para adicionar exceção ao Windows Defender
const defenderException = function() {
    window.electron.addDefenderException();
};

// Inicia a função de adicionar exceção ao Defender
defenderException();

// Configura as mensagens de download e extração
DownloadMessage('Downloading:', 'Aguardando o download...');
ExtractMessage(60, {
    text1: 'Extraindo:',
    text2: 'arquivos'
});
